/*
 * Copyright (C) 2002 Benjamin Hummel (benjamin@datamaze.de)
 *
 * commands.h - implementation of internal commands
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef COMMANDS_H
#define COMMANDS_H

/* prototype of an internal command */
typedef int command_fct (int, char **, int);

/* storage struct for internal commands */
struct command_struct
{
	char *name;
	command_fct *fct;
};

/* export the command table */
extern struct command_struct commands[];
extern int num_commands;

/* these are the internal command functions */
int
cmd_help (int argc, char **argv, int line);

int
cmd_get (int argc, char **argv, int line);

int
cmd_quit (int argc, char **argv, int line);

int
cmd_mode (int argc, char **argv, int line);

int
cmd_set (int argc, char **argv, int line);

int
cmd_camera (int argc, char **argv, int line);

int
cmd_info (int argc, char **argv, int line);

#endif // COMMANDS_H


