/*
 * Copyright (C) 2002 Benjamin Hummel (benjamin@datamaze.de)
 *
 * error.h - some simple error handling code
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef ERROR_H
#define ERROR_H

extern int fail_on_error;

/* the same as exit, but cleans up (handles,...) */
void
save_exit (int code);

/* display critical error message and exit */
void
error_crit (char *s);

/* display parser error. exit if fail_on_error is set  */
int
error_parse (int line_num, char *err_str, char *cmd_str);

#endif // ERROR_H
